<?php
/* --------------------------------------------------------------
 ClearMenuCacheHandler.php 2020-04-06
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace Gambio\Admin\Layout\Menu\CommandHandlers;

use Gambio\Admin\Layout\Menu\AdminMenuService;
use Gambio\Admin\Layout\Menu\Commands\ClearMenuCache;

/**
 * Class ClearMenuCacheHandler
 * @package Gambio\Admin\Layout\Menu\CommandHandlers
 */
class ClearMenuCacheHandler
{
    /**
     * @var AdminMenuService
     */
    private $service;
    
    
    /**
     * ClearMenuCacheHandler constructor.
     *
     * @param AdminMenuService $service
     */
    public function __construct(AdminMenuService $service)
    {
        $this->service = $service;
    }
    
    
    /**
     * Callback method that deletes the admin menu cache file by using the dedicated service.
     *
     * @param ClearMenuCache $command
     *
     * @return ClearMenuCache
     */
    public function __invoke(ClearMenuCache $command): ClearMenuCache
    {
        $this->service->deleteMenuCache();
        
        return $command;
    }
}